#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

HA_PREFIX="/usr/syno/synoha"

. $HA_PREFIX/etc.defaults/rc.subr

HA_UNBINDING=$UNBINDING
FLAG_HA_PASSIVE_IS_BINDING=$PASSIVE_IS_BINDING

case "$1" in
	start)
		synoha_log "SxxPre start"
		rm -f $FLAG_HA_SXX_ROLE_PREPASSIVE
		touch $FLAG_HA_SXX_ROLE_PREACTIVE

		$SYNOHA_BIN --update-hotspare-conf

		# HA #1892, pgsql migration will take a long time
		if [ -f "$SYNO_HA_UPG" ]; then
			if ! $SYNOHA_BIN --upg-is-active ; then
				synoservicecfg --pause-by-reason pgsql ha-upg
				synoservicecfg --pause-by-reason httpd-sys ha-upg
			fi
		fi

		# Workaround for DSM #78157
		synoha_log " start $SYNO_INITD_DIR/S01iptables.sh..."
		$SYNO_INITD_DIR/S01iptables.sh start
		synoha_log " start $SYNO_INITD_DIR/S01tc.sh..."
		$SYNO_INITD_DIR/S01tc.sh start
		synoha_log " start $SYNO_INITD_DIR/S02bootup.sh..."
		$SYNO_INITD_DIR/S02bootup.sh start

		synoservicecfg --resume-all ha-passive
		;;
	stop)
		synoha_log "SxxPre stop"
		rm -f $FLAG_HA_SXX_ROLE_PREACTIVE
		touch $FLAG_HA_SXX_ROLE_PREPASSIVE

		if [ -f "$SYNO_HA_UPG" ]; then
			if $SYNOHA_BIN --upg-is-active ; then
				# start upgrade, active go here to skip pause some services
				synoservicecfg --pause-all ha-passive ha-keep-session
			else
				# after passive reboot, passive go here to become passive
				synoservicecfg --pause-all ha-passive ha-on-passive
			fi

			if ! $SYNOHA_BIN --upg-is-active ; then
				# HA #1892, pgsql migration will take a long time
				synoservicecfg --resume-by-reason pgsql ha-upg
				synoservicecfg --resume-by-reason httpd-sys ha-upg
			fi
		elif $SYNOHA_BIN --check-ha-is-binding; then
			# binding
			if [ -f $FLAG_HA_PASSIVE_IS_BINDING ]; then
				synoservicecfg --pause-all ha-passive ha-on-passive
			else
				synoservicecfg --pause-all ha-passive ha-keep-session
			fi
			# Don't forget etc/rc
			synoservicecfg --pause-by-reason synowifid ha-not-support
			synoservicecfg --pause-by-reason bluetoothd ha-not-support
			synoservicecfg --pause-by-reason btacd ha-not-support
		else
			# switch over
			synoservicecfg --pause-all ha-passive ha-on-passive
		fi

		if [ -e $HA_UNBINDING ]; then
			$SYNOHA_BIN --set-vaai-default
		fi

		{
			# even remove usb called at SxxPost stop
			# usb ups may be plugged between SxxPost ~ Dummy stop
			# following stop ups after Dummy stop before become passive
			if ! synobootseq --is-safe-shutdown &>/dev/null ; then
				. /usr/syno/bin/synoupscommon
				HA_ROLE_PREACTIVE=$ROLE_PREACTIVE
				while [ "$HA_ROLE_PREACTIVE" == "`$SYNOHA_BIN --local-role`" ]; do sleep 3 ; done
				StopUps log
			fi
		}&
		;;
	restart)
		stop
		start
		;;
	status)
		;;
	*)
		echo "Usages: $0 [start|stop|restart|status]"
		;;
esac
exit $?

